#import "MountController.h"

@implementation MountController

- (void)loadImage:(NSString *)path
{
    //NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];
    
    [progress startAnimation:self];
    
    [statusText setStringValue:NSLocalizedString(@"Detecting image type...", nil)];
    [statusText display];
    NSDictionary *atts = [[NSFileManager defaultManager] fileAttributesAtPath:path traverseLink:YES];
    int size = [[atts objectForKey:NSFileSize] intValue];
    int blocksize = 2048;
//    if (((float)size / 2048) == (size / 2048)) {
//        blocksize = 2048;
//    } else
    if (((float)size / 2352) == (size / 2352)) {
        blocksize = 2352;
    }
    
    [statusText setStringValue:NSLocalizedString(@"Loading system extension...", nil)];
    [statusText display];
    [mDelegate loadKernelExtension];
    
    [statusText setStringValue:[NSString stringWithFormat:NSLocalizedString(@"Loading \"%@\"...", nil), [[path pathComponents] lastObject]]];
    [statusText display];
    NSTask *mountTask;
    mountTask = [[NSTask alloc] init];
    [mountTask setLaunchPath:[[NSUserDefaults standardUserDefaults] objectForKey:@"pathToToastImageMounter"]];
    if (blocksize == 2352) {
        [mountTask setArguments:[NSArray arrayWithObjects:path, @"-hybrid", @"-imagekey", @"blocksize=2352", nil]];
    } else {
        [mountTask setArguments:[NSArray arrayWithObjects:path, @"-imagekey", @"blocksize=2048", nil]];
    }
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(taskDidEnd:) name:NSTaskDidTerminateNotification object:mountTask];
    
    [mountTask launch];
}

- (void)setDelegate:(id)aDelegate
{
    mDelegate = aDelegate;
}

- (void)taskDidEnd:(NSNotification *)aNotification
{
    [[aNotification object] release];
    [progress stopAnimation:self];
    [mDelegate removeSubview:view];
    [self release];
}

- (NSView *)view
{
    return view;
}

@end
